///////////////////////////////////////////////////////////////////////////////
// Copyright (c) 1995/2004 Xilinx, Inc.
// All Right Reserved.
///////////////////////////////////////////////////////////////////////////////
//   ____  ____
//  /   /\/   /
// /___/  \  /    Vendor : Xilinx
// \   \   \/     Version : 10.1
//  \   \         Description : Xilinx Functional Simulation Library Component
//  /   /                  11-Gigabit Transceiver for High-Speed I/O DUAL Simulation Model
// /___/   /\     Filename : GT11_DUAL.v
// \   \  /  \    Timestamp : Fri Jun 18 10:57:01 PDT 2004
//  \___\/\___\
//
// Revision:
//    03/23/04 - Initial version.
//    05/16/05 - Changed default values for some parameters and removed two parameters. Fixed CR#207101.
//    09/06/05 - Fixed CR#215006. Attribute default values update.  
//    02/22/06 - CR#226003 - Added integer, real parameter type
//    02/28/06 - CR#226322 - Addition of new parameters and change of default values for some parameters.
// End Revision

`timescale 1 ps / 1 ps 

module GT11_DUAL (
	CHBONDOA,
	CHBONDOB,
	DOA,
	DOB,
	DRDYA,
	DRDYB,
	RXBUFERRA,
	RXBUFERRB,
	RXCALFAILA,
	RXCALFAILB,
	RXCHARISCOMMAA,
	RXCHARISCOMMAB,
	RXCHARISKA,
	RXCHARISKB,
	RXCOMMADETA,
	RXCOMMADETB,
	RXCRCOUTA,
	RXCRCOUTB,
	RXCYCLELIMITA,
	RXCYCLELIMITB,
	RXDATAA,
	RXDATAB,
	RXDISPERRA,
	RXDISPERRB,
	RXLOCKA,
	RXLOCKB,
	RXLOSSOFSYNCA,
	RXLOSSOFSYNCB,
	RXMCLKA,
	RXMCLKB,
	RXNOTINTABLEA,
	RXNOTINTABLEB,
	RXPCSHCLKOUTA,
	RXPCSHCLKOUTB,
	RXREALIGNA,
	RXREALIGNB,
	RXRECCLK1A,
	RXRECCLK1B,
	RXRECCLK2A,
	RXRECCLK2B,
	RXRUNDISPA,
	RXRUNDISPB,
	RXSIGDETA,
	RXSIGDETB,
	RXSTATUSA,
	RXSTATUSB,
	TX1NA,
	TX1NB,
	TX1PA,
	TX1PB,
	TXBUFERRA,
	TXBUFERRB,
	TXCALFAILA,
	TXCALFAILB,
	TXCRCOUTA,
	TXCRCOUTB,
	TXCYCLELIMITA,
	TXCYCLELIMITB,
	TXKERRA,
	TXKERRB,
	TXLOCKA,
	TXLOCKB,
	TXOUTCLK1A,
	TXOUTCLK1B,
	TXOUTCLK2A,
	TXOUTCLK2B,
	TXPCSHCLKOUTA,
	TXPCSHCLKOUTB,
	TXRUNDISPA,
	TXRUNDISPB,
	CHBONDIA,
	CHBONDIB,
	DADDRA,
	DADDRB,
	DCLKA,
	DCLKB,
	DENA,
	DENB,
	DIA,
	DIB,
	DWEA,
	DWEB,
	ENCHANSYNCA,
	ENCHANSYNCB,
	ENMCOMMAALIGNA,
	ENMCOMMAALIGNB,
	ENPCOMMAALIGNA,
	ENPCOMMAALIGNB,
	GREFCLKA,
	GREFCLKB,
	LOOPBACKA,
	LOOPBACKB,
	POWERDOWNA,
	POWERDOWNB,
	REFCLK1A,
	REFCLK1B,
	REFCLK2A,
	REFCLK2B,
	RX1NA,
	RX1NB,
	RX1PA,
	RX1PB,
	RXBLOCKSYNC64B66BUSEA,
	RXBLOCKSYNC64B66BUSEB,
	RXCLKSTABLEA,
	RXCLKSTABLEB,
	RXCOMMADETUSEA,
	RXCOMMADETUSEB,
	RXCRCCLKA,
	RXCRCCLKB,
	RXCRCDATAVALIDA,
	RXCRCDATAVALIDB,
	RXCRCDATAWIDTHA,
	RXCRCDATAWIDTHB,
	RXCRCINA,
	RXCRCINB,
	RXCRCINITA,
	RXCRCINITB,
	RXCRCINTCLKA,
	RXCRCINTCLKB,
	RXCRCPDA,
	RXCRCPDB,
	RXCRCRESETA,
	RXCRCRESETB,
	RXDATAWIDTHA,
	RXDATAWIDTHB,
	RXDEC64B66BUSEA,
	RXDEC64B66BUSEB,
	RXDEC8B10BUSEA,
	RXDEC8B10BUSEB,
	RXDESCRAM64B66BUSEA,
	RXDESCRAM64B66BUSEB,
	RXIGNOREBTFA,
	RXIGNOREBTFB,
	RXINTDATAWIDTHA,
	RXINTDATAWIDTHB,
	RXPMARESETA,
	RXPMARESETB,
	RXPOLARITYA,
	RXPOLARITYB,
	RXRESETA,
	RXRESETB,
	RXSLIDEA,
	RXSLIDEB,
	RXSYNCA,
	RXSYNCB,
	RXUSRCLK2A,
	RXUSRCLK2B,
	RXUSRCLKA,
	RXUSRCLKB,
	TXBYPASS8B10BA,
	TXBYPASS8B10BB,
	TXCHARDISPMODEA,
	TXCHARDISPMODEB,
	TXCHARDISPVALA,
	TXCHARDISPVALB,
	TXCHARISKA,
	TXCHARISKB,
	TXCLKSTABLEA,
	TXCLKSTABLEB,
	TXCRCCLKA,
	TXCRCCLKB,
	TXCRCDATAVALIDA,
	TXCRCDATAVALIDB,
	TXCRCDATAWIDTHA,
	TXCRCDATAWIDTHB,
	TXCRCINA,
	TXCRCINB,
	TXCRCINITA,
	TXCRCINITB,
	TXCRCINTCLKA,
	TXCRCINTCLKB,
	TXCRCPDA,
	TXCRCPDB,
	TXCRCRESETA,
	TXCRCRESETB,
	TXDATAA,
	TXDATAB,
	TXDATAWIDTHA,
	TXDATAWIDTHB,
	TXENC64B66BUSEA,
	TXENC64B66BUSEB,
	TXENC8B10BUSEA,
	TXENC8B10BUSEB,
	TXENOOBA,
	TXENOOBB,
	TXGEARBOX64B66BUSEA,
	TXGEARBOX64B66BUSEB,
	TXINHIBITA,
	TXINHIBITB,
	TXINTDATAWIDTHA,
	TXINTDATAWIDTHB,
	TXPMARESETA,
	TXPMARESETB,
	TXPOLARITYA,
	TXPOLARITYB,
	TXRESETA,
	TXRESETB,
	TXSCRAM64B66BUSEA,
	TXSCRAM64B66BUSEB,
	TXSYNCA,
	TXSYNCB,
	TXUSRCLK2A,
	TXUSRCLK2B,
	TXUSRCLKA,
	TXUSRCLKB
);

parameter BANDGAPSEL_A = "FALSE";
parameter BANDGAPSEL_B = "FALSE";
parameter BIASRESSEL_A = "FALSE";
parameter BIASRESSEL_B = "FALSE";
parameter CCCB_ARBITRATOR_DISABLE_A = "FALSE";
parameter CCCB_ARBITRATOR_DISABLE_B = "FALSE";
parameter CHAN_BOND_MODE_A = "NONE";
parameter CHAN_BOND_MODE_B = "NONE";
parameter CHAN_BOND_ONE_SHOT_A = "FALSE";
parameter CHAN_BOND_ONE_SHOT_B = "FALSE";
parameter CHAN_BOND_SEQ_1_1_A = 11'b00000000000;
parameter CHAN_BOND_SEQ_1_1_B = 11'b00000000000;
parameter CHAN_BOND_SEQ_1_2_A = 11'b00000000000;
parameter CHAN_BOND_SEQ_1_2_B = 11'b00000000000;
parameter CHAN_BOND_SEQ_1_3_A = 11'b00000000000;
parameter CHAN_BOND_SEQ_1_3_B = 11'b00000000000;
parameter CHAN_BOND_SEQ_1_4_A = 11'b00000000000;
parameter CHAN_BOND_SEQ_1_4_B = 11'b00000000000;
parameter CHAN_BOND_SEQ_1_MASK_A = 4'b1110;
parameter CHAN_BOND_SEQ_1_MASK_B = 4'b1110;
parameter CHAN_BOND_SEQ_2_1_A = 11'b00000000000;
parameter CHAN_BOND_SEQ_2_1_B = 11'b00000000000;
parameter CHAN_BOND_SEQ_2_2_A = 11'b00000000000;
parameter CHAN_BOND_SEQ_2_2_B = 11'b00000000000;
parameter CHAN_BOND_SEQ_2_3_A = 11'b00000000000;
parameter CHAN_BOND_SEQ_2_3_B = 11'b00000000000;
parameter CHAN_BOND_SEQ_2_4_A = 11'b00000000000;
parameter CHAN_BOND_SEQ_2_4_B = 11'b00000000000;
parameter CHAN_BOND_SEQ_2_MASK_A = 4'b1110;
parameter CHAN_BOND_SEQ_2_MASK_B = 4'b1110;
parameter CHAN_BOND_SEQ_2_USE_A = "FALSE";
parameter CHAN_BOND_SEQ_2_USE_B = "FALSE";
parameter CLK_CORRECT_USE_A = "FALSE";
parameter CLK_CORRECT_USE_B = "FALSE";
parameter CLK_COR_8B10B_DE_A = "FALSE";
parameter CLK_COR_8B10B_DE_B = "FALSE";
parameter CLK_COR_SEQ_1_1_A = 11'b00000000000;
parameter CLK_COR_SEQ_1_1_B = 11'b00000000000;
parameter CLK_COR_SEQ_1_2_A = 11'b00000000000;
parameter CLK_COR_SEQ_1_2_B = 11'b00000000000;
parameter CLK_COR_SEQ_1_3_A = 11'b00000000000;
parameter CLK_COR_SEQ_1_3_B = 11'b00000000000;
parameter CLK_COR_SEQ_1_4_A = 11'b00000000000;
parameter CLK_COR_SEQ_1_4_B = 11'b00000000000;
parameter CLK_COR_SEQ_1_MASK_A = 4'b1110;
parameter CLK_COR_SEQ_1_MASK_B = 4'b1110;
parameter CLK_COR_SEQ_2_1_A = 11'b00000000000;
parameter CLK_COR_SEQ_2_1_B = 11'b00000000000;
parameter CLK_COR_SEQ_2_2_A = 11'b00000000000;
parameter CLK_COR_SEQ_2_2_B = 11'b00000000000;
parameter CLK_COR_SEQ_2_3_A = 11'b00000000000;
parameter CLK_COR_SEQ_2_3_B = 11'b00000000000;
parameter CLK_COR_SEQ_2_4_A = 11'b00000000000;
parameter CLK_COR_SEQ_2_4_B = 11'b00000000000;
parameter CLK_COR_SEQ_2_MASK_A = 4'b1110;
parameter CLK_COR_SEQ_2_MASK_B = 4'b1110;
parameter CLK_COR_SEQ_2_USE_A = "FALSE";
parameter CLK_COR_SEQ_2_USE_B = "FALSE";
parameter CLK_COR_SEQ_DROP_A = "FALSE";
parameter CLK_COR_SEQ_DROP_B = "FALSE";
parameter COMMA32_A = "FALSE";
parameter COMMA32_B = "FALSE";
parameter COMMA_10B_MASK_A = 10'h3FF;
parameter COMMA_10B_MASK_B = 10'h3FF;
parameter CYCLE_LIMIT_SEL_A = 2'b00;
parameter CYCLE_LIMIT_SEL_B = 2'b00;
parameter DCDR_FILTER_A = 3'b010;
parameter DCDR_FILTER_B = 3'b010;
parameter DEC_MCOMMA_DETECT_A = "TRUE";
parameter DEC_MCOMMA_DETECT_B = "TRUE";
parameter DEC_PCOMMA_DETECT_A = "TRUE";
parameter DEC_PCOMMA_DETECT_B = "TRUE";
parameter DEC_VALID_COMMA_ONLY_A = "TRUE";
parameter DEC_VALID_COMMA_ONLY_B = "TRUE";
parameter DIGRX_FWDCLK_A = 2'b00;
parameter DIGRX_FWDCLK_B = 2'b00;
parameter DIGRX_SYNC_MODE_A = "FALSE";
parameter DIGRX_SYNC_MODE_B = "FALSE";
parameter ENABLE_DCDR_A = "FALSE";
parameter ENABLE_DCDR_B = "FALSE";
parameter FDET_HYS_CAL_A = 3'b010;
parameter FDET_HYS_CAL_B = 3'b010;
parameter FDET_HYS_SEL_A = 3'b100;
parameter FDET_HYS_SEL_B = 3'b100;
parameter FDET_LCK_CAL_A = 3'b100;
parameter FDET_LCK_CAL_B = 3'b100;
parameter FDET_LCK_SEL_A = 3'b001;
parameter FDET_LCK_SEL_B = 3'b001;
parameter IREFBIASMODE_A = 2'b11;
parameter IREFBIASMODE_B = 2'b11;
parameter LOOPCAL_WAIT_A = 2'b00;
parameter LOOPCAL_WAIT_B = 2'b00;
parameter MCOMMA_32B_VALUE_A = 32'h00000000;
parameter MCOMMA_32B_VALUE_B = 32'h00000000;
parameter MCOMMA_DETECT_A = "TRUE";
parameter MCOMMA_DETECT_B = "TRUE";
parameter OPPOSITE_SELECT_A = "FALSE";
parameter OPPOSITE_SELECT_B = "FALSE";
parameter PCOMMA_32B_VALUE_A = 32'h00000000;
parameter PCOMMA_32B_VALUE_B = 32'h00000000;
parameter PCOMMA_DETECT_A = "TRUE";
parameter PCOMMA_DETECT_B = "TRUE";
parameter PCS_BIT_SLIP_A = "FALSE";
parameter PCS_BIT_SLIP_B = "FALSE";
parameter PMACLKENABLE_A = "TRUE";
parameter PMACLKENABLE_B = "TRUE";
parameter PMACOREPWRENABLE_A = "TRUE";
parameter PMACOREPWRENABLE_B = "TRUE";
parameter PMAIREFTRIM_A = 4'b0111;
parameter PMAIREFTRIM_B = 4'b0111;
parameter PMAVBGCTRL_A = 5'b00000;
parameter PMAVBGCTRL_B = 5'b00000;
parameter PMAVREFTRIM_A = 4'b0111;
parameter PMAVREFTRIM_B = 4'b0111;
parameter PMA_BIT_SLIP_A = "FALSE";
parameter PMA_BIT_SLIP_B = "FALSE";
parameter POWER_ENABLE_A = "TRUE";
parameter POWER_ENABLE_B = "TRUE";
parameter REPEATER_A = "FALSE";
parameter REPEATER_B = "FALSE";
parameter RXACTST_A = "FALSE";
parameter RXACTST_B = "FALSE";
parameter RXAFEEQ_A = 9'b000000000;
parameter RXAFEEQ_B = 9'b000000000;
parameter RXAFEPD_A = "FALSE";
parameter RXAFEPD_B = "FALSE";
parameter RXAFETST_A = "FALSE";
parameter RXAFETST_B = "FALSE";
parameter RXAPD_A = "FALSE";
parameter RXAPD_B = "FALSE";
parameter RXAREGCTRL_A = 5'b00000;
parameter RXAREGCTRL_B = 5'b00000;
parameter RXASYNCDIVIDE_A = 2'b11;
parameter RXASYNCDIVIDE_B = 2'b11;
parameter RXBY_32_A = "FALSE";
parameter RXBY_32_B = "FALSE";
parameter RXCDRLOS_A = 6'b000000;
parameter RXCDRLOS_B = 6'b000000;
parameter RXCLK0_FORCE_PMACLK_A = "FALSE";
parameter RXCLK0_FORCE_PMACLK_B = "FALSE";
parameter RXCLKMODE_A = 6'b110001;
parameter RXCLKMODE_B = 6'b110001;
parameter RXCLMODE_A = 2'b00;
parameter RXCLMODE_B = 2'b00;
parameter RXCMADJ_A = 2'b01;
parameter RXCMADJ_B = 2'b01;
parameter RXCPSEL_A = "TRUE";
parameter RXCPSEL_B = "TRUE";
parameter RXCPTST_A = "FALSE";
parameter RXCPTST_B = "FALSE";
parameter RXCRCCLOCKDOUBLE_A = "FALSE";
parameter RXCRCCLOCKDOUBLE_B = "FALSE";
parameter RXCRCENABLE_A = "FALSE";
parameter RXCRCENABLE_B = "FALSE";
parameter RXCRCINITVAL_A = 32'h00000000;
parameter RXCRCINITVAL_B = 32'h00000000;
parameter RXCRCINVERTGEN_A = "FALSE";
parameter RXCRCINVERTGEN_B = "FALSE";
parameter RXCRCSAMECLOCK_A = "FALSE";
parameter RXCRCSAMECLOCK_B = "FALSE";
parameter RXCTRL1_A = 10'h200;
parameter RXCTRL1_B = 10'h200;
parameter RXCYCLE_LIMIT_SEL_A = 2'b00;
parameter RXCYCLE_LIMIT_SEL_B = 2'b00;
parameter RXDATA_SEL_A = 2'b00;
parameter RXDATA_SEL_B = 2'b00;
parameter RXDCCOUPLE_A = "FALSE";
parameter RXDCCOUPLE_B = "FALSE";
parameter RXDIGRESET_A = "FALSE";
parameter RXDIGRESET_B = "FALSE";
parameter RXDIGRX_A = "FALSE";
parameter RXDIGRX_B = "FALSE";
parameter RXEQ_A = 64'h4000000000000000;
parameter RXEQ_B = 64'h4000000000000000;
parameter RXFDCAL_CLOCK_DIVIDE_A = "NONE";
parameter RXFDCAL_CLOCK_DIVIDE_B = "NONE";
parameter RXFDET_HYS_CAL_A = 3'b010;
parameter RXFDET_HYS_CAL_B = 3'b010;
parameter RXFDET_HYS_SEL_A = 3'b100;
parameter RXFDET_HYS_SEL_B = 3'b100;
parameter RXFDET_LCK_CAL_A = 3'b100;
parameter RXFDET_LCK_CAL_B = 3'b100;
parameter RXFDET_LCK_SEL_A = 3'b001;
parameter RXFDET_LCK_SEL_B = 3'b001;
parameter RXFECONTROL1_A = 2'b00;
parameter RXFECONTROL1_B = 2'b00;
parameter RXFECONTROL2_A = 3'b000;
parameter RXFECONTROL2_B = 3'b000;
parameter RXFETUNE_A = 2'b01;
parameter RXFETUNE_B = 2'b01;
parameter RXLB_A = "FALSE";
parameter RXLB_B = "FALSE";
parameter RXLKADJ_A = 5'b00000;
parameter RXLKADJ_B = 5'b00000;
parameter RXLKAPD_A = "FALSE";
parameter RXLKAPD_B = "FALSE";
parameter RXLOOPCAL_WAIT_A = 2'b00;
parameter RXLOOPCAL_WAIT_B = 2'b00;
parameter RXLOOPFILT_A = 4'b0111;
parameter RXLOOPFILT_B = 4'b0111;
parameter RXMODE_A = 6'b000000;
parameter RXMODE_B = 6'b000000;
parameter RXPDDTST_A = "TRUE";
parameter RXPDDTST_B = "TRUE";
parameter RXPD_A = "FALSE";
parameter RXPD_B = "FALSE";
parameter RXPMACLKSEL_A = "REFCLK1";
parameter RXPMACLKSEL_B = "REFCLK1";
parameter RXRCPADJ_A = 3'b011;
parameter RXRCPADJ_B = 3'b011;
parameter RXRCPPD_A = "FALSE";
parameter RXRCPPD_B = "FALSE";
parameter RXRECCLK1_USE_SYNC_A = "FALSE";
parameter RXRECCLK1_USE_SYNC_B = "FALSE";
parameter RXRIBADJ_A = 2'b11;
parameter RXRIBADJ_B = 2'b11;
parameter RXRPDPD_A = "FALSE";
parameter RXRPDPD_B = "FALSE";
parameter RXRSDPD_A = "FALSE";
parameter RXRSDPD_B = "FALSE";
parameter RXSLOWDOWN_CAL_A = 2'b00;
parameter RXSLOWDOWN_CAL_B = 2'b00;
parameter RXTUNE_A = 13'h0000;
parameter RXTUNE_B = 13'h0000;
parameter RXVCODAC_INIT_A = 10'b1010000000;
parameter RXVCODAC_INIT_B = 10'b1010000000;
parameter RXVCO_CTRL_ENABLE_A = "FALSE";
parameter RXVCO_CTRL_ENABLE_B = "FALSE";
parameter RX_BUFFER_USE_A = "TRUE";
parameter RX_BUFFER_USE_B = "TRUE";
parameter RX_CLOCK_DIVIDER_A = 2'b00;
parameter RX_CLOCK_DIVIDER_B = 2'b00;
parameter SAMPLE_8X_A = "FALSE";
parameter SAMPLE_8X_B = "FALSE";
parameter SLOWDOWN_CAL_A = 2'b00;
parameter SLOWDOWN_CAL_B = 2'b00;
parameter TXABPMACLKSEL_A = "REFCLK1";
parameter TXABPMACLKSEL_B = "REFCLK1";
parameter TXAPD_A = "FALSE";
parameter TXAPD_B = "FALSE";
parameter TXAREFBIASSEL_A = "TRUE";
parameter TXAREFBIASSEL_B = "TRUE";
parameter TXASYNCDIVIDE_A = 2'b11;
parameter TXASYNCDIVIDE_B = 2'b11;
parameter TXCLK0_FORCE_PMACLK_A = "FALSE";
parameter TXCLK0_FORCE_PMACLK_B = "FALSE";
parameter TXCLKMODE_A = 4'b1001;
parameter TXCLKMODE_B = 4'b1001;
parameter TXCLMODE_A = 2'b00;
parameter TXCLMODE_B = 2'b00;
parameter TXCPSEL_A = "TRUE";
parameter TXCPSEL_B = "TRUE";
parameter TXCRCCLOCKDOUBLE_A = "FALSE";
parameter TXCRCCLOCKDOUBLE_B = "FALSE";
parameter TXCRCENABLE_A = "FALSE";
parameter TXCRCENABLE_B = "FALSE";
parameter TXCRCINITVAL_A = 32'h00000000;
parameter TXCRCINITVAL_B = 32'h00000000;
parameter TXCRCINVERTGEN_A = "FALSE";
parameter TXCRCINVERTGEN_B = "FALSE";
parameter TXCRCSAMECLOCK_A = "FALSE";
parameter TXCRCSAMECLOCK_B = "FALSE";
parameter TXCTRL1_A = 10'h200;
parameter TXCTRL1_B = 10'h200;
parameter TXDATA_SEL_A = 2'b00;
parameter TXDATA_SEL_B = 2'b00;
parameter TXDAT_PRDRV_DAC_A = 3'b111;
parameter TXDAT_PRDRV_DAC_B = 3'b111;
parameter TXDAT_TAP_DAC_A = 5'b10110;
parameter TXDAT_TAP_DAC_B = 5'b10110;
parameter TXDIGPD_A = "FALSE";
parameter TXDIGPD_B = "FALSE";
parameter TXFDCAL_CLOCK_DIVIDE_A = "NONE";
parameter TXFDCAL_CLOCK_DIVIDE_B = "NONE";
parameter TXHIGHSIGNALEN_A = "TRUE";
parameter TXHIGHSIGNALEN_B = "TRUE";
parameter TXLOOPFILT_A = 4'b0111;
parameter TXLOOPFILT_B = 4'b0111;
parameter TXLVLSHFTPD_A = "FALSE";
parameter TXLVLSHFTPD_B = "FALSE";
parameter TXOUTCLK1_USE_SYNC_A = "FALSE";
parameter TXOUTCLK1_USE_SYNC_B = "FALSE";
parameter TXPD_A = "FALSE";
parameter TXPD_B = "FALSE";
parameter TXPHASESEL_A = "FALSE";
parameter TXPHASESEL_B = "FALSE";
parameter TXPOST_PRDRV_DAC_A = 3'b111;
parameter TXPOST_PRDRV_DAC_B = 3'b111;
parameter TXPOST_TAP_DAC_A = 5'b01110;
parameter TXPOST_TAP_DAC_B = 5'b01110;
parameter TXPOST_TAP_PD_A = "TRUE";
parameter TXPOST_TAP_PD_B = "TRUE";
parameter TXPRE_PRDRV_DAC_A = 3'b111;
parameter TXPRE_PRDRV_DAC_B = 3'b111;
parameter TXPRE_TAP_DAC_A = 5'b00000;
parameter TXPRE_TAP_DAC_B = 5'b00000;
parameter TXPRE_TAP_PD_A = "TRUE";
parameter TXPRE_TAP_PD_B = "TRUE";
parameter TXSLEWRATE_A = "FALSE";
parameter TXSLEWRATE_B = "FALSE";
parameter TXTERMTRIM_A = 4'b1100;
parameter TXTERMTRIM_B = 4'b1100;
parameter TXTUNE_A = 13'h0000;
parameter TXTUNE_B = 13'h0000;
parameter TX_BUFFER_USE_A = "TRUE";
parameter TX_BUFFER_USE_B = "TRUE";
parameter TX_CLOCK_DIVIDER_A = 2'b00;
parameter TX_CLOCK_DIVIDER_B = 2'b00;
parameter VCODAC_INIT_A = 10'b1010000000;
parameter VCODAC_INIT_B = 10'b1010000000;
parameter VCO_CTRL_ENABLE_A = "FALSE";
parameter VCO_CTRL_ENABLE_B = "FALSE";
parameter VREFBIASMODE_A = 2'b11;
parameter VREFBIASMODE_B = 2'b11;
parameter integer ALIGN_COMMA_WORD_A = 4;
parameter integer ALIGN_COMMA_WORD_B = 4;
parameter integer CHAN_BOND_LIMIT_A = 16;
parameter integer CHAN_BOND_LIMIT_B = 16;
parameter integer CHAN_BOND_SEQ_LEN_A = 1;
parameter integer CHAN_BOND_SEQ_LEN_B = 1;
parameter integer CLK_COR_MAX_LAT_A = 48;
parameter integer CLK_COR_MAX_LAT_B = 48;
parameter integer CLK_COR_MIN_LAT_A = 36;
parameter integer CLK_COR_MIN_LAT_B = 36;
parameter integer CLK_COR_SEQ_LEN_A = 1;
parameter integer CLK_COR_SEQ_LEN_B = 1;
parameter integer RXOUTDIV2SEL_A = 1;
parameter integer RXOUTDIV2SEL_B = 1;
parameter integer RXPLLNDIVSEL_A = 8;
parameter integer RXPLLNDIVSEL_B = 8;
parameter integer RXUSRDIVISOR_A = 1;
parameter integer RXUSRDIVISOR_B = 1;
parameter integer SH_CNT_MAX_A = 64;
parameter integer SH_CNT_MAX_B = 64;
parameter integer SH_INVALID_CNT_MAX_A = 16;
parameter integer SH_INVALID_CNT_MAX_B = 16;
parameter integer TXOUTDIV2SEL_A = 1;
parameter integer TXOUTDIV2SEL_B = 1;
parameter integer TXPLLNDIVSEL_A = 8;
parameter integer TXPLLNDIVSEL_B = 8;


output DRDYA;
output DRDYB;
output RXBUFERRA;
output RXBUFERRB;
output RXCALFAILA;
output RXCALFAILB;
output RXCOMMADETA;
output RXCOMMADETB;
output RXCYCLELIMITA;
output RXCYCLELIMITB;
output RXLOCKA;
output RXLOCKB;
output RXMCLKA;
output RXMCLKB;
output RXPCSHCLKOUTA;
output RXPCSHCLKOUTB;
output RXREALIGNA;
output RXREALIGNB;
output RXRECCLK1A;
output RXRECCLK1B;
output RXRECCLK2A;
output RXRECCLK2B;
output RXSIGDETA;
output RXSIGDETB;
output TX1NA;
output TX1NB;
output TX1PA;
output TX1PB;
output TXBUFERRA;
output TXBUFERRB;
output TXCALFAILA;
output TXCALFAILB;
output TXCYCLELIMITA;
output TXCYCLELIMITB;
output TXLOCKA;
output TXLOCKB;
output TXOUTCLK1A;
output TXOUTCLK1B;
output TXOUTCLK2A;
output TXOUTCLK2B;
output TXPCSHCLKOUTA;
output TXPCSHCLKOUTB;
output [15:0] DOA;
output [15:0] DOB;
output [1:0] RXLOSSOFSYNCA;
output [1:0] RXLOSSOFSYNCB;
output [31:0] RXCRCOUTA;
output [31:0] RXCRCOUTB;
output [31:0] TXCRCOUTA;
output [31:0] TXCRCOUTB;
output [4:0] CHBONDOA;
output [4:0] CHBONDOB;
output [5:0] RXSTATUSA;
output [5:0] RXSTATUSB;
output [63:0] RXDATAA;
output [63:0] RXDATAB;
output [7:0] RXCHARISCOMMAA;
output [7:0] RXCHARISCOMMAB;
output [7:0] RXCHARISKA;
output [7:0] RXCHARISKB;
output [7:0] RXDISPERRA;
output [7:0] RXDISPERRB;
output [7:0] RXNOTINTABLEA;
output [7:0] RXNOTINTABLEB;
output [7:0] RXRUNDISPA;
output [7:0] RXRUNDISPB;
output [7:0] TXKERRA;
output [7:0] TXKERRB;
output [7:0] TXRUNDISPA;
output [7:0] TXRUNDISPB;

input DCLKA;
input DCLKB;
input DENA;
input DENB;
input DWEA;
input DWEB;
input ENCHANSYNCA;
input ENCHANSYNCB;
input ENMCOMMAALIGNA;
input ENMCOMMAALIGNB;
input ENPCOMMAALIGNA;
input ENPCOMMAALIGNB;
input GREFCLKA;
input GREFCLKB;
input POWERDOWNA;
input POWERDOWNB;
input REFCLK1A;
input REFCLK1B;
input REFCLK2A;
input REFCLK2B;
input RX1NA;
input RX1NB;
input RX1PA;
input RX1PB;
input RXBLOCKSYNC64B66BUSEA;
input RXBLOCKSYNC64B66BUSEB;
input RXCLKSTABLEA;
input RXCLKSTABLEB;
input RXCOMMADETUSEA;
input RXCOMMADETUSEB;
input RXCRCCLKA;
input RXCRCCLKB;
input RXCRCDATAVALIDA;
input RXCRCDATAVALIDB;
input RXCRCINITA;
input RXCRCINITB;
input RXCRCINTCLKA;
input RXCRCINTCLKB;
input RXCRCPDA;
input RXCRCPDB;
input RXCRCRESETA;
input RXCRCRESETB;
input RXDEC64B66BUSEA;
input RXDEC64B66BUSEB;
input RXDEC8B10BUSEA;
input RXDEC8B10BUSEB;
input RXDESCRAM64B66BUSEA;
input RXDESCRAM64B66BUSEB;
input RXIGNOREBTFA;
input RXIGNOREBTFB;
input RXPMARESETA;
input RXPMARESETB;
input RXPOLARITYA;
input RXPOLARITYB;
input RXRESETA;
input RXRESETB;
input RXSLIDEA;
input RXSLIDEB;
input RXSYNCA;
input RXSYNCB;
input RXUSRCLK2A;
input RXUSRCLK2B;
input RXUSRCLKA;
input RXUSRCLKB;
input TXCLKSTABLEA;
input TXCLKSTABLEB;
input TXCRCCLKA;
input TXCRCCLKB;
input TXCRCDATAVALIDA;
input TXCRCDATAVALIDB;
input TXCRCINITA;
input TXCRCINITB;
input TXCRCINTCLKA;
input TXCRCINTCLKB;
input TXCRCPDA;
input TXCRCPDB;
input TXCRCRESETA;
input TXCRCRESETB;
input TXENC64B66BUSEA;
input TXENC64B66BUSEB;
input TXENC8B10BUSEA;
input TXENC8B10BUSEB;
input TXENOOBA;
input TXENOOBB;
input TXGEARBOX64B66BUSEA;
input TXGEARBOX64B66BUSEB;
input TXINHIBITA;
input TXINHIBITB;
input TXPMARESETA;
input TXPMARESETB;
input TXPOLARITYA;
input TXPOLARITYB;
input TXRESETA;
input TXRESETB;
input TXSCRAM64B66BUSEA;
input TXSCRAM64B66BUSEB;
input TXSYNCA;
input TXSYNCB;
input TXUSRCLK2A;
input TXUSRCLK2B;
input TXUSRCLKA;
input TXUSRCLKB;
input [15:0] DIA;
input [15:0] DIB;
input [1:0] LOOPBACKA;
input [1:0] LOOPBACKB;
input [1:0] RXDATAWIDTHA;
input [1:0] RXDATAWIDTHB;
input [1:0] RXINTDATAWIDTHA;
input [1:0] RXINTDATAWIDTHB;
input [1:0] TXDATAWIDTHA;
input [1:0] TXDATAWIDTHB;
input [1:0] TXINTDATAWIDTHA;
input [1:0] TXINTDATAWIDTHB;
input [2:0] RXCRCDATAWIDTHA;
input [2:0] RXCRCDATAWIDTHB;
input [2:0] TXCRCDATAWIDTHA;
input [2:0] TXCRCDATAWIDTHB;
input [4:0] CHBONDIA;
input [4:0] CHBONDIB;
input [63:0] RXCRCINA;
input [63:0] RXCRCINB;
input [63:0] TXCRCINA;
input [63:0] TXCRCINB;
input [63:0] TXDATAA;
input [63:0] TXDATAB;
input [7:0] DADDRA;
input [7:0] DADDRB;
input [7:0] TXBYPASS8B10BA;
input [7:0] TXBYPASS8B10BB;
input [7:0] TXCHARDISPMODEA;
input [7:0] TXCHARDISPMODEB;
input [7:0] TXCHARDISPVALA;
input [7:0] TXCHARDISPVALB;
input [7:0] TXCHARISKA;
input [7:0] TXCHARISKB;

wire [15:0] COMBUSINB;
wire [15:0] COMBUSINA;

GT11 gt11_a (
	.CHBONDO(CHBONDOA),
	.COMBUSOUT(COMBUSINB),
	.DO(DOA),
	.DRDY(DRDYA),
	.RXBUFERR(RXBUFERRA),
	.RXCALFAIL(RXCALFAILA),
	.RXCHARISCOMMA(RXCHARISCOMMAA),
	.RXCHARISK(RXCHARISKA),
	.RXCOMMADET(RXCOMMADETA),
	.RXCRCOUT(RXCRCOUTA),
	.RXCYCLELIMIT(RXCYCLELIMITA),
	.RXDATA(RXDATAA),
	.RXDISPERR(RXDISPERRA),
	.RXLOCK(RXLOCKA),
	.RXLOSSOFSYNC(RXLOSSOFSYNCA),
	.RXMCLK(RXMCLKA),
	.RXNOTINTABLE(RXNOTINTABLEA),
	.RXPCSHCLKOUT(RXPCSHCLKOUTA),
	.RXREALIGN(RXREALIGNA),
	.RXRECCLK1(RXRECCLK1A),
	.RXRECCLK2(RXRECCLK2A),
	.RXRUNDISP(RXRUNDISPA),
	.RXSIGDET(RXSIGDETA),
	.RXSTATUS(RXSTATUSA),
	.TX1N(TX1NA),
	.TX1P(TX1PA),
	.TXBUFERR(TXBUFERRA),
	.TXCALFAIL(TXCALFAILA),
	.TXCRCOUT(TXCRCOUTA),
	.TXCYCLELIMIT(TXCYCLELIMITA),
	.TXKERR(TXKERRA),
	.TXLOCK(TXLOCKA),
	.TXOUTCLK1(TXOUTCLK1A),
	.TXOUTCLK2(TXOUTCLK2A),
	.TXPCSHCLKOUT(TXPCSHCLKOUTA),
	.TXRUNDISP(TXRUNDISPA),
	.CHBONDI(CHBONDIA),
	.COMBUSIN(COMBUSINA),
	.DADDR(DADDRA),
	.DCLK(DCLKA),
	.DEN(DENA),
	.DI(DIA),
	.DWE(DWEA),
	.ENCHANSYNC(ENCHANSYNCA),
	.ENMCOMMAALIGN(ENMCOMMAALIGNA),
	.ENPCOMMAALIGN(ENPCOMMAALIGNA),
	.GREFCLK(GREFCLKA),
	.LOOPBACK(LOOPBACKA),
	.POWERDOWN(POWERDOWNA),
	.REFCLK1(REFCLK1A),
	.REFCLK2(REFCLK2A),
	.RX1N(RX1NA),
	.RX1P(RX1PA),
	.RXBLOCKSYNC64B66BUSE(RXBLOCKSYNC64B66BUSEA),
	.RXCLKSTABLE(RXCLKSTABLEA),
	.RXCOMMADETUSE(RXCOMMADETUSEA),
	.RXCRCCLK(RXCRCCLKA),
	.RXCRCDATAVALID(RXCRCDATAVALIDA),
	.RXCRCDATAWIDTH(RXCRCDATAWIDTHA),
	.RXCRCIN(RXCRCINA),
	.RXCRCINIT(RXCRCINITA),
	.RXCRCINTCLK(RXCRCINTCLKA),
	.RXCRCPD(RXCRCPDA),
	.RXCRCRESET(RXCRCRESETA),
	.RXDATAWIDTH(RXDATAWIDTHA),
	.RXDEC64B66BUSE(RXDEC64B66BUSEA),
	.RXDEC8B10BUSE(RXDEC8B10BUSEA),
	.RXDESCRAM64B66BUSE(RXDESCRAM64B66BUSEA),
	.RXIGNOREBTF(RXIGNOREBTFA),
	.RXINTDATAWIDTH(RXINTDATAWIDTHA),
	.RXPMARESET(RXPMARESETA),
	.RXPOLARITY(RXPOLARITYA),
	.RXRESET(RXRESETA),
	.RXSLIDE(RXSLIDEA),
	.RXSYNC(RXSYNCA),
	.RXUSRCLK(RXUSRCLKA),
	.RXUSRCLK2(RXUSRCLK2A),
	.TXBYPASS8B10B(TXBYPASS8B10BA),
	.TXCHARDISPMODE(TXCHARDISPMODEA),
	.TXCHARDISPVAL(TXCHARDISPVALA),
	.TXCHARISK(TXCHARISKA),
	.TXCLKSTABLE(TXCLKSTABLEA),
	.TXCRCCLK(TXCRCCLKA),
	.TXCRCDATAVALID(TXCRCDATAVALIDA),
	.TXCRCDATAWIDTH(TXCRCDATAWIDTHA),
	.TXCRCIN(TXCRCINA),
	.TXCRCINIT(TXCRCINITA),
	.TXCRCINTCLK(TXCRCINTCLKA),
	.TXCRCPD(TXCRCPDA),
	.TXCRCRESET(TXCRCRESETA),
	.TXDATA(TXDATAA),
	.TXDATAWIDTH(TXDATAWIDTHA),
	.TXENC64B66BUSE(TXENC64B66BUSEA),
	.TXENC8B10BUSE(TXENC8B10BUSEA),
	.TXENOOB(TXENOOBA),
	.TXGEARBOX64B66BUSE(TXGEARBOX64B66BUSEA),
	.TXINHIBIT(TXINHIBITA),
	.TXINTDATAWIDTH(TXINTDATAWIDTHA),
	.TXPMARESET(TXPMARESETA),
	.TXPOLARITY(TXPOLARITYA),
	.TXRESET(TXRESETA),
	.TXSCRAM64B66BUSE(TXSCRAM64B66BUSEA),
	.TXSYNC(TXSYNCA),
	.TXUSRCLK(TXUSRCLKA),
	.TXUSRCLK2(TXUSRCLK2A)
);

GT11 gt11_b (
	.CHBONDO(CHBONDOB),
	.COMBUSOUT(COMBUSINA),
	.DO(DOB),
	.DRDY(DRDYB),
	.RXBUFERR(RXBUFERRB),
	.RXCALFAIL(RXCALFAILB),
	.RXCHARISCOMMA(RXCHARISCOMMAB),
	.RXCHARISK(RXCHARISKB),
	.RXCOMMADET(RXCOMMADETB),
	.RXCRCOUT(RXCRCOUTB),
	.RXCYCLELIMIT(RXCYCLELIMITB),
	.RXDATA(RXDATAB),
	.RXDISPERR(RXDISPERRB),
	.RXLOCK(RXLOCKB),
	.RXLOSSOFSYNC(RXLOSSOFSYNCB),
	.RXMCLK(RXMCLKB),
	.RXNOTINTABLE(RXNOTINTABLEB),
	.RXPCSHCLKOUT(RXPCSHCLKOUTB),
	.RXREALIGN(RXREALIGNB),
	.RXRECCLK1(RXRECCLK1B),
	.RXRECCLK2(RXRECCLK2B),
	.RXRUNDISP(RXRUNDISPB),
	.RXSIGDET(RXSIGDETB),
	.RXSTATUS(RXSTATUSB),
	.TX1N(TX1NB),
	.TX1P(TX1PB),
	.TXBUFERR(TXBUFERRB),
	.TXCALFAIL(TXCALFAILB),
	.TXCRCOUT(TXCRCOUTB),
	.TXCYCLELIMIT(TXCYCLELIMITB),
	.TXKERR(TXKERRB),
	.TXLOCK(TXLOCKB),
	.TXOUTCLK1(TXOUTCLK1B),
	.TXOUTCLK2(TXOUTCLK2B),
	.TXPCSHCLKOUT(TXPCSHCLKOUTB),
	.TXRUNDISP(TXRUNDISPB),
	.CHBONDI(CHBONDIB),
	.COMBUSIN(COMBUSINB),
	.DADDR(DADDRB),
	.DCLK(DCLKB),
	.DEN(DENB),
	.DI(DIB),
	.DWE(DWEB),
	.ENCHANSYNC(ENCHANSYNCB),
	.ENMCOMMAALIGN(ENMCOMMAALIGNB),
	.ENPCOMMAALIGN(ENPCOMMAALIGNB),
	.GREFCLK(GREFCLKB),
	.LOOPBACK(LOOPBACKB),
	.POWERDOWN(POWERDOWNB),
	.REFCLK1(REFCLK1B),
	.REFCLK2(REFCLK2B),
	.RX1N(RX1NB),
	.RX1P(RX1PB),
	.RXBLOCKSYNC64B66BUSE(RXBLOCKSYNC64B66BUSEB),
	.RXCLKSTABLE(RXCLKSTABLEB),
	.RXCOMMADETUSE(RXCOMMADETUSEB),
	.RXCRCCLK(RXCRCCLKB),
	.RXCRCDATAVALID(RXCRCDATAVALIDB),
	.RXCRCDATAWIDTH(RXCRCDATAWIDTHB),
	.RXCRCIN(RXCRCINB),
	.RXCRCINIT(RXCRCINITB),
	.RXCRCINTCLK(RXCRCINTCLKB),
	.RXCRCPD(RXCRCPDB),
	.RXCRCRESET(RXCRCRESETB),
	.RXDATAWIDTH(RXDATAWIDTHB),
	.RXDEC64B66BUSE(RXDEC64B66BUSEB),
	.RXDEC8B10BUSE(RXDEC8B10BUSEB),
	.RXDESCRAM64B66BUSE(RXDESCRAM64B66BUSEB),
	.RXIGNOREBTF(RXIGNOREBTFB),
	.RXINTDATAWIDTH(RXINTDATAWIDTHB),
	.RXPMARESET(RXPMARESETB),
	.RXPOLARITY(RXPOLARITYB),
	.RXRESET(RXRESETB),
	.RXSLIDE(RXSLIDEB),
	.RXSYNC(RXSYNCB),
	.RXUSRCLK(RXUSRCLKB),
	.RXUSRCLK2(RXUSRCLK2B),
	.TXBYPASS8B10B(TXBYPASS8B10BB),
	.TXCHARDISPMODE(TXCHARDISPMODEB),
	.TXCHARDISPVAL(TXCHARDISPVALB),
	.TXCHARISK(TXCHARISKB),
	.TXCLKSTABLE(TXCLKSTABLEB),
	.TXCRCCLK(TXCRCCLKB),
	.TXCRCDATAVALID(TXCRCDATAVALIDB),
	.TXCRCDATAWIDTH(TXCRCDATAWIDTHB),
	.TXCRCIN(TXCRCINB),
	.TXCRCINIT(TXCRCINITB),
	.TXCRCINTCLK(TXCRCINTCLKB),
	.TXCRCPD(TXCRCPDB),
	.TXCRCRESET(TXCRCRESETB),
	.TXDATA(TXDATAB),
	.TXDATAWIDTH(TXDATAWIDTHB),
	.TXENC64B66BUSE(TXENC64B66BUSEB),
	.TXENC8B10BUSE(TXENC8B10BUSEB),
	.TXENOOB(TXENOOBB),
	.TXGEARBOX64B66BUSE(TXGEARBOX64B66BUSEB),
	.TXINHIBIT(TXINHIBITB),
	.TXINTDATAWIDTH(TXINTDATAWIDTHB),
	.TXPMARESET(TXPMARESETB),
	.TXPOLARITY(TXPOLARITYB),
	.TXRESET(TXRESETB),
	.TXSCRAM64B66BUSE(TXSCRAM64B66BUSEB),
	.TXSYNC(TXSYNCB),
	.TXUSRCLK(TXUSRCLKB),
	.TXUSRCLK2(TXUSRCLK2B)

);

defparam gt11_a.ALIGN_COMMA_WORD = ALIGN_COMMA_WORD_A;
defparam gt11_a.BANDGAPSEL = BANDGAPSEL_A;
defparam gt11_a.BIASRESSEL = BIASRESSEL_A;
defparam gt11_a.CCCB_ARBITRATOR_DISABLE = CCCB_ARBITRATOR_DISABLE_A;
defparam gt11_a.CHAN_BOND_LIMIT = CHAN_BOND_LIMIT_A;
defparam gt11_a.CHAN_BOND_MODE = CHAN_BOND_MODE_A;
defparam gt11_a.CHAN_BOND_ONE_SHOT = CHAN_BOND_ONE_SHOT_A;
defparam gt11_a.CHAN_BOND_SEQ_1_1 = CHAN_BOND_SEQ_1_1_A;
defparam gt11_a.CHAN_BOND_SEQ_1_2 = CHAN_BOND_SEQ_1_2_A;
defparam gt11_a.CHAN_BOND_SEQ_1_3 = CHAN_BOND_SEQ_1_3_A;
defparam gt11_a.CHAN_BOND_SEQ_1_4 = CHAN_BOND_SEQ_1_4_A;
defparam gt11_a.CHAN_BOND_SEQ_1_MASK = CHAN_BOND_SEQ_1_MASK_A;
defparam gt11_a.CHAN_BOND_SEQ_2_1 = CHAN_BOND_SEQ_2_1_A;
defparam gt11_a.CHAN_BOND_SEQ_2_2 = CHAN_BOND_SEQ_2_2_A;
defparam gt11_a.CHAN_BOND_SEQ_2_3 = CHAN_BOND_SEQ_2_3_A;
defparam gt11_a.CHAN_BOND_SEQ_2_4 = CHAN_BOND_SEQ_2_4_A;
defparam gt11_a.CHAN_BOND_SEQ_2_MASK = CHAN_BOND_SEQ_2_MASK_A;
defparam gt11_a.CHAN_BOND_SEQ_2_USE = CHAN_BOND_SEQ_2_USE_A;
defparam gt11_a.CHAN_BOND_SEQ_LEN = CHAN_BOND_SEQ_LEN_A;
defparam gt11_a.CLK_CORRECT_USE = CLK_CORRECT_USE_A;
defparam gt11_a.CLK_COR_8B10B_DE = CLK_COR_8B10B_DE_A;
defparam gt11_a.CLK_COR_MAX_LAT = CLK_COR_MAX_LAT_A;
defparam gt11_a.CLK_COR_MIN_LAT = CLK_COR_MIN_LAT_A;
defparam gt11_a.CLK_COR_SEQ_1_1 = CLK_COR_SEQ_1_1_A;
defparam gt11_a.CLK_COR_SEQ_1_2 = CLK_COR_SEQ_1_2_A;
defparam gt11_a.CLK_COR_SEQ_1_3 = CLK_COR_SEQ_1_3_A;
defparam gt11_a.CLK_COR_SEQ_1_4 = CLK_COR_SEQ_1_4_A;
defparam gt11_a.CLK_COR_SEQ_1_MASK = CLK_COR_SEQ_1_MASK_A;
defparam gt11_a.CLK_COR_SEQ_2_1 = CLK_COR_SEQ_2_1_A;
defparam gt11_a.CLK_COR_SEQ_2_2 = CLK_COR_SEQ_2_2_A;
defparam gt11_a.CLK_COR_SEQ_2_3 = CLK_COR_SEQ_2_3_A;
defparam gt11_a.CLK_COR_SEQ_2_4 = CLK_COR_SEQ_2_4_A;
defparam gt11_a.CLK_COR_SEQ_2_MASK = CLK_COR_SEQ_2_MASK_A;
defparam gt11_a.CLK_COR_SEQ_2_USE = CLK_COR_SEQ_2_USE_A;
defparam gt11_a.CLK_COR_SEQ_DROP = CLK_COR_SEQ_DROP_A;
defparam gt11_a.CLK_COR_SEQ_LEN = CLK_COR_SEQ_LEN_A;
defparam gt11_a.COMMA32 = COMMA32_A;
defparam gt11_a.COMMA_10B_MASK = COMMA_10B_MASK_A;
defparam gt11_a.CYCLE_LIMIT_SEL = CYCLE_LIMIT_SEL_A;
defparam gt11_a.DCDR_FILTER = DCDR_FILTER_A;
defparam gt11_a.DEC_MCOMMA_DETECT = DEC_MCOMMA_DETECT_A;
defparam gt11_a.DEC_PCOMMA_DETECT = DEC_PCOMMA_DETECT_A;
defparam gt11_a.DEC_VALID_COMMA_ONLY = DEC_VALID_COMMA_ONLY_A;
defparam gt11_a.DIGRX_FWDCLK = DIGRX_FWDCLK_A;
defparam gt11_a.DIGRX_SYNC_MODE = DIGRX_SYNC_MODE_A;
defparam gt11_a.ENABLE_DCDR = ENABLE_DCDR_A;
defparam gt11_a.FDET_HYS_CAL = FDET_HYS_CAL_A;
defparam gt11_a.FDET_HYS_SEL = FDET_HYS_SEL_A;
defparam gt11_a.FDET_LCK_CAL = FDET_LCK_CAL_A;
defparam gt11_a.FDET_LCK_SEL = FDET_LCK_SEL_A;
defparam gt11_a.GT11_MODE = "A";
defparam gt11_a.IREFBIASMODE = IREFBIASMODE_A;
defparam gt11_a.LOOPCAL_WAIT = LOOPCAL_WAIT_A;
defparam gt11_a.MCOMMA_32B_VALUE = MCOMMA_32B_VALUE_A;
defparam gt11_a.MCOMMA_DETECT = MCOMMA_DETECT_A;
defparam gt11_a.OPPOSITE_SELECT = OPPOSITE_SELECT_A;
defparam gt11_a.PCOMMA_32B_VALUE = PCOMMA_32B_VALUE_A;
defparam gt11_a.PCOMMA_DETECT = PCOMMA_DETECT_A;
defparam gt11_a.PCS_BIT_SLIP = PCS_BIT_SLIP_A;
defparam gt11_a.PMACLKENABLE = PMACLKENABLE_A;
defparam gt11_a.PMACOREPWRENABLE = PMACOREPWRENABLE_A;
defparam gt11_a.PMAIREFTRIM = PMAIREFTRIM_A;
defparam gt11_a.PMAVBGCTRL = PMAVBGCTRL_A;
defparam gt11_a.PMAVREFTRIM = PMAVREFTRIM_A;
defparam gt11_a.PMA_BIT_SLIP = PMA_BIT_SLIP_A;
defparam gt11_a.POWER_ENABLE = POWER_ENABLE_A;
defparam gt11_a.REPEATER = REPEATER_A;
defparam gt11_a.RXACTST = RXACTST_A;
defparam gt11_a.RXAFEEQ = RXAFEEQ_A;
defparam gt11_a.RXAFEPD = RXAFEPD_A;
defparam gt11_a.RXAFETST = RXAFETST_A;
defparam gt11_a.RXAPD = RXAPD_A;
defparam gt11_a.RXAREGCTRL = RXAREGCTRL_A;
defparam gt11_a.RXASYNCDIVIDE = RXASYNCDIVIDE_A;
defparam gt11_a.RXBY_32 = RXBY_32_A;
defparam gt11_a.RXCDRLOS = RXCDRLOS_A;
defparam gt11_a.RXCLK0_FORCE_PMACLK = RXCLK0_FORCE_PMACLK_A;
defparam gt11_a.RXCLKMODE = RXCLKMODE_A;
defparam gt11_a.RXCLMODE = RXCLMODE_A;
defparam gt11_a.RXCMADJ = RXCMADJ_A;
defparam gt11_a.RXCPSEL = RXCPSEL_A;
defparam gt11_a.RXCPTST = RXCPTST_A;
defparam gt11_a.RXCRCCLOCKDOUBLE = RXCRCCLOCKDOUBLE_A;
defparam gt11_a.RXCRCENABLE = RXCRCENABLE_A;
defparam gt11_a.RXCRCINITVAL = RXCRCINITVAL_A;
defparam gt11_a.RXCRCINVERTGEN = RXCRCINVERTGEN_A;
defparam gt11_a.RXCRCSAMECLOCK = RXCRCSAMECLOCK_A;
defparam gt11_a.RXCTRL1 = RXCTRL1_A;
defparam gt11_a.RXCYCLE_LIMIT_SEL = RXCYCLE_LIMIT_SEL_A;
defparam gt11_a.RXDATA_SEL = RXDATA_SEL_A;
defparam gt11_a.RXDCCOUPLE = RXDCCOUPLE_A;
defparam gt11_a.RXDIGRESET = RXDIGRESET_A;
defparam gt11_a.RXDIGRX = RXDIGRX_A;
defparam gt11_a.RXEQ = RXEQ_A;
defparam gt11_a.RXFDCAL_CLOCK_DIVIDE = RXFDCAL_CLOCK_DIVIDE_A;
defparam gt11_a.RXFDET_HYS_CAL = RXFDET_HYS_CAL_A;
defparam gt11_a.RXFDET_HYS_SEL = RXFDET_HYS_SEL_A;
defparam gt11_a.RXFDET_LCK_CAL = RXFDET_LCK_CAL_A;
defparam gt11_a.RXFDET_LCK_SEL = RXFDET_LCK_SEL_A;
defparam gt11_a.RXFECONTROL1 = RXFECONTROL1_A;
defparam gt11_a.RXFECONTROL2 = RXFECONTROL2_A;
defparam gt11_a.RXFETUNE = RXFETUNE_A;
defparam gt11_a.RXLB = RXLB_A;
defparam gt11_a.RXLKADJ = RXLKADJ_A;
defparam gt11_a.RXLKAPD = RXLKAPD_A;
defparam gt11_a.RXLOOPCAL_WAIT = RXLOOPCAL_WAIT_A;
defparam gt11_a.RXLOOPFILT = RXLOOPFILT_A;
defparam gt11_a.RXMODE = RXMODE_A;
defparam gt11_a.RXOUTDIV2SEL = RXOUTDIV2SEL_A;
defparam gt11_a.RXPD = RXPD_A;
defparam gt11_a.RXPDDTST = RXPDDTST_A;
defparam gt11_a.RXPLLNDIVSEL = RXPLLNDIVSEL_A;
defparam gt11_a.RXPMACLKSEL = RXPMACLKSEL_A;
defparam gt11_a.RXRCPADJ = RXRCPADJ_A;
defparam gt11_a.RXRCPPD = RXRCPPD_A;
defparam gt11_a.RXRECCLK1_USE_SYNC = RXRECCLK1_USE_SYNC_A;
defparam gt11_a.RXRIBADJ = RXRIBADJ_A;
defparam gt11_a.RXRPDPD = RXRPDPD_A;
defparam gt11_a.RXRSDPD = RXRSDPD_A;
defparam gt11_a.RXSLOWDOWN_CAL = RXSLOWDOWN_CAL_A;
defparam gt11_a.RXTUNE = RXTUNE_A;
defparam gt11_a.RXUSRDIVISOR = RXUSRDIVISOR_A;
defparam gt11_a.RXVCODAC_INIT = RXVCODAC_INIT_A;
defparam gt11_a.RXVCO_CTRL_ENABLE = RXVCO_CTRL_ENABLE_A;
defparam gt11_a.RX_BUFFER_USE = RX_BUFFER_USE_A;
defparam gt11_a.RX_CLOCK_DIVIDER = RX_CLOCK_DIVIDER_A;
defparam gt11_a.SAMPLE_8X = SAMPLE_8X_A;
defparam gt11_a.SH_CNT_MAX = SH_CNT_MAX_A;
defparam gt11_a.SH_INVALID_CNT_MAX = SH_INVALID_CNT_MAX_A;
defparam gt11_a.SLOWDOWN_CAL = SLOWDOWN_CAL_A;
defparam gt11_a.TXABPMACLKSEL = TXABPMACLKSEL_A;
defparam gt11_a.TXAPD = TXAPD_A;
defparam gt11_a.TXAREFBIASSEL = TXAREFBIASSEL_A;
defparam gt11_a.TXASYNCDIVIDE = TXASYNCDIVIDE_A;
defparam gt11_a.TXCLK0_FORCE_PMACLK = TXCLK0_FORCE_PMACLK_A;
defparam gt11_a.TXCLKMODE = TXCLKMODE_A;
defparam gt11_a.TXCLMODE = TXCLMODE_A;
defparam gt11_a.TXCPSEL = TXCPSEL_A;
defparam gt11_a.TXCRCCLOCKDOUBLE = TXCRCCLOCKDOUBLE_A;
defparam gt11_a.TXCRCENABLE = TXCRCENABLE_A;
defparam gt11_a.TXCRCINITVAL = TXCRCINITVAL_A;
defparam gt11_a.TXCRCINVERTGEN = TXCRCINVERTGEN_A;
defparam gt11_a.TXCRCSAMECLOCK = TXCRCSAMECLOCK_A;
defparam gt11_a.TXCTRL1 = TXCTRL1_A;
defparam gt11_a.TXDATA_SEL = TXDATA_SEL_A;
defparam gt11_a.TXDAT_PRDRV_DAC = TXDAT_PRDRV_DAC_A;
defparam gt11_a.TXDAT_TAP_DAC = TXDAT_TAP_DAC_A;
defparam gt11_a.TXDIGPD = TXDIGPD_A;
defparam gt11_a.TXFDCAL_CLOCK_DIVIDE = TXFDCAL_CLOCK_DIVIDE_A;
defparam gt11_a.TXHIGHSIGNALEN = TXHIGHSIGNALEN_A;
defparam gt11_a.TXLOOPFILT = TXLOOPFILT_A;
defparam gt11_a.TXLVLSHFTPD = TXLVLSHFTPD_A;
defparam gt11_a.TXOUTCLK1_USE_SYNC = TXOUTCLK1_USE_SYNC_A;
defparam gt11_a.TXOUTDIV2SEL = TXOUTDIV2SEL_A;
defparam gt11_a.TXPD = TXPD_A;
defparam gt11_a.TXPHASESEL = TXPHASESEL_A;
defparam gt11_a.TXPLLNDIVSEL = TXPLLNDIVSEL_A;
defparam gt11_a.TXPOST_PRDRV_DAC = TXPOST_PRDRV_DAC_A;
defparam gt11_a.TXPOST_TAP_DAC = TXPOST_TAP_DAC_A;
defparam gt11_a.TXPOST_TAP_PD = TXPOST_TAP_PD_A;
defparam gt11_a.TXPRE_PRDRV_DAC = TXPRE_PRDRV_DAC_A;
defparam gt11_a.TXPRE_TAP_DAC = TXPRE_TAP_DAC_A;
defparam gt11_a.TXPRE_TAP_PD = TXPRE_TAP_PD_A;
defparam gt11_a.TXSLEWRATE = TXSLEWRATE_A;
defparam gt11_a.TXTERMTRIM = TXTERMTRIM_A;
defparam gt11_a.TXTUNE = TXTUNE_A;
defparam gt11_a.TX_BUFFER_USE = TX_BUFFER_USE_A;
defparam gt11_a.TX_CLOCK_DIVIDER = TX_CLOCK_DIVIDER_A;
defparam gt11_a.VCODAC_INIT = VCODAC_INIT_A;
defparam gt11_a.VCO_CTRL_ENABLE = VCO_CTRL_ENABLE_A;
defparam gt11_a.VREFBIASMODE = VREFBIASMODE_A;

defparam gt11_b.ALIGN_COMMA_WORD = ALIGN_COMMA_WORD_B;
defparam gt11_b.BANDGAPSEL = BANDGAPSEL_B;
defparam gt11_b.BIASRESSEL = BIASRESSEL_B;
defparam gt11_b.CCCB_ARBITRATOR_DISABLE = CCCB_ARBITRATOR_DISABLE_B;
defparam gt11_b.CHAN_BOND_LIMIT = CHAN_BOND_LIMIT_B;
defparam gt11_b.CHAN_BOND_MODE = CHAN_BOND_MODE_B;
defparam gt11_b.CHAN_BOND_ONE_SHOT = CHAN_BOND_ONE_SHOT_B;
defparam gt11_b.CHAN_BOND_SEQ_1_1 = CHAN_BOND_SEQ_1_1_B;
defparam gt11_b.CHAN_BOND_SEQ_1_2 = CHAN_BOND_SEQ_1_2_B;
defparam gt11_b.CHAN_BOND_SEQ_1_3 = CHAN_BOND_SEQ_1_3_B;
defparam gt11_b.CHAN_BOND_SEQ_1_4 = CHAN_BOND_SEQ_1_4_B;
defparam gt11_b.CHAN_BOND_SEQ_1_MASK = CHAN_BOND_SEQ_1_MASK_B;
defparam gt11_b.CHAN_BOND_SEQ_2_1 = CHAN_BOND_SEQ_2_1_B;
defparam gt11_b.CHAN_BOND_SEQ_2_2 = CHAN_BOND_SEQ_2_2_B;
defparam gt11_b.CHAN_BOND_SEQ_2_3 = CHAN_BOND_SEQ_2_3_B;
defparam gt11_b.CHAN_BOND_SEQ_2_4 = CHAN_BOND_SEQ_2_4_B;
defparam gt11_b.CHAN_BOND_SEQ_2_MASK = CHAN_BOND_SEQ_2_MASK_B;
defparam gt11_b.CHAN_BOND_SEQ_2_USE = CHAN_BOND_SEQ_2_USE_B;
defparam gt11_b.CHAN_BOND_SEQ_LEN = CHAN_BOND_SEQ_LEN_B;
defparam gt11_b.CLK_CORRECT_USE = CLK_CORRECT_USE_B;
defparam gt11_b.CLK_COR_8B10B_DE = CLK_COR_8B10B_DE_B;
defparam gt11_b.CLK_COR_MAX_LAT = CLK_COR_MAX_LAT_B;
defparam gt11_b.CLK_COR_MIN_LAT = CLK_COR_MIN_LAT_B;
defparam gt11_b.CLK_COR_SEQ_1_1 = CLK_COR_SEQ_1_1_B;
defparam gt11_b.CLK_COR_SEQ_1_2 = CLK_COR_SEQ_1_2_B;
defparam gt11_b.CLK_COR_SEQ_1_3 = CLK_COR_SEQ_1_3_B;
defparam gt11_b.CLK_COR_SEQ_1_4 = CLK_COR_SEQ_1_4_B;
defparam gt11_b.CLK_COR_SEQ_1_MASK = CLK_COR_SEQ_1_MASK_B;
defparam gt11_b.CLK_COR_SEQ_2_1 = CLK_COR_SEQ_2_1_B;
defparam gt11_b.CLK_COR_SEQ_2_2 = CLK_COR_SEQ_2_2_B;
defparam gt11_b.CLK_COR_SEQ_2_3 = CLK_COR_SEQ_2_3_B;
defparam gt11_b.CLK_COR_SEQ_2_4 = CLK_COR_SEQ_2_4_B;
defparam gt11_b.CLK_COR_SEQ_2_MASK = CLK_COR_SEQ_2_MASK_B;
defparam gt11_b.CLK_COR_SEQ_2_USE = CLK_COR_SEQ_2_USE_B;
defparam gt11_b.CLK_COR_SEQ_DROP = CLK_COR_SEQ_DROP_B;
defparam gt11_b.CLK_COR_SEQ_LEN = CLK_COR_SEQ_LEN_B;
defparam gt11_b.COMMA32 = COMMA32_B;
defparam gt11_b.COMMA_10B_MASK = COMMA_10B_MASK_B;
defparam gt11_b.CYCLE_LIMIT_SEL = CYCLE_LIMIT_SEL_B;
defparam gt11_b.DCDR_FILTER = DCDR_FILTER_B;
defparam gt11_b.DEC_MCOMMA_DETECT = DEC_MCOMMA_DETECT_B;
defparam gt11_b.DEC_PCOMMA_DETECT = DEC_PCOMMA_DETECT_B;
defparam gt11_b.DEC_VALID_COMMA_ONLY = DEC_VALID_COMMA_ONLY_B;
defparam gt11_b.DIGRX_FWDCLK = DIGRX_FWDCLK_B;
defparam gt11_b.DIGRX_SYNC_MODE = DIGRX_SYNC_MODE_B;
defparam gt11_b.ENABLE_DCDR = ENABLE_DCDR_B;
defparam gt11_b.FDET_HYS_CAL = FDET_HYS_CAL_B;
defparam gt11_b.FDET_HYS_SEL = FDET_HYS_SEL_B;
defparam gt11_b.FDET_LCK_CAL = FDET_LCK_CAL_B;
defparam gt11_b.FDET_LCK_SEL = FDET_LCK_SEL_B;
defparam gt11_b.GT11_MODE = "B";
defparam gt11_b.IREFBIASMODE = IREFBIASMODE_B;
defparam gt11_b.LOOPCAL_WAIT = LOOPCAL_WAIT_B;
defparam gt11_b.MCOMMA_32B_VALUE = MCOMMA_32B_VALUE_B;
defparam gt11_b.MCOMMA_DETECT = MCOMMA_DETECT_B;
defparam gt11_b.OPPOSITE_SELECT = OPPOSITE_SELECT_B;
defparam gt11_b.PCOMMA_32B_VALUE = PCOMMA_32B_VALUE_B;
defparam gt11_b.PCOMMA_DETECT = PCOMMA_DETECT_B;
defparam gt11_b.PCS_BIT_SLIP = PCS_BIT_SLIP_B;
defparam gt11_b.PMACLKENABLE = PMACLKENABLE_B;
defparam gt11_b.PMACOREPWRENABLE = PMACOREPWRENABLE_B;
defparam gt11_b.PMAIREFTRIM = PMAIREFTRIM_B;
defparam gt11_b.PMAVBGCTRL = PMAVBGCTRL_B;
defparam gt11_b.PMAVREFTRIM = PMAVREFTRIM_B;
defparam gt11_b.PMA_BIT_SLIP = PMA_BIT_SLIP_B;
defparam gt11_b.POWER_ENABLE = POWER_ENABLE_B;
defparam gt11_b.REPEATER = REPEATER_B;
defparam gt11_b.RXACTST = RXACTST_B;
defparam gt11_b.RXAFEEQ = RXAFEEQ_B;
defparam gt11_b.RXAFEPD = RXAFEPD_B;
defparam gt11_b.RXAFETST = RXAFETST_B;
defparam gt11_b.RXAPD = RXAPD_B;
defparam gt11_a.RXAREGCTRL = RXAREGCTRL_B;
defparam gt11_b.RXASYNCDIVIDE = RXASYNCDIVIDE_B;
defparam gt11_b.RXBY_32 = RXBY_32_B;
defparam gt11_b.RXCDRLOS = RXCDRLOS_B;
defparam gt11_b.RXCLK0_FORCE_PMACLK = RXCLK0_FORCE_PMACLK_B;
defparam gt11_b.RXCLKMODE = RXCLKMODE_B;
defparam gt11_a.RXCLMODE = RXCLMODE_B;
defparam gt11_b.RXCMADJ = RXCMADJ_B;
defparam gt11_b.RXCPSEL = RXCPSEL_B;
defparam gt11_b.RXCPTST = RXCPTST_B;
defparam gt11_b.RXCRCCLOCKDOUBLE = RXCRCCLOCKDOUBLE_B;
defparam gt11_b.RXCRCENABLE = RXCRCENABLE_B;
defparam gt11_b.RXCRCINITVAL = RXCRCINITVAL_B;
defparam gt11_b.RXCRCINVERTGEN = RXCRCINVERTGEN_B;
defparam gt11_b.RXCRCSAMECLOCK = RXCRCSAMECLOCK_B;
defparam gt11_b.RXCTRL1 = RXCTRL1_B;
defparam gt11_b.RXCYCLE_LIMIT_SEL = RXCYCLE_LIMIT_SEL_B;
defparam gt11_b.RXDATA_SEL = RXDATA_SEL_B;
defparam gt11_b.RXDCCOUPLE = RXDCCOUPLE_B;
defparam gt11_b.RXDIGRESET = RXDIGRESET_B;
defparam gt11_b.RXDIGRX = RXDIGRX_B;
defparam gt11_b.RXEQ = RXEQ_B;
defparam gt11_b.RXFDCAL_CLOCK_DIVIDE = RXFDCAL_CLOCK_DIVIDE_B;
defparam gt11_b.RXFDET_HYS_CAL = RXFDET_HYS_CAL_B;
defparam gt11_b.RXFDET_HYS_SEL = RXFDET_HYS_SEL_B;
defparam gt11_b.RXFDET_LCK_CAL = RXFDET_LCK_CAL_B;
defparam gt11_b.RXFDET_LCK_SEL = RXFDET_LCK_SEL_B;
defparam gt11_b.RXFECONTROL1 = RXFECONTROL1_B;
defparam gt11_b.RXFECONTROL2 = RXFECONTROL2_B;
defparam gt11_b.RXFETUNE = RXFETUNE_B;
defparam gt11_b.RXLB = RXLB_B;
defparam gt11_b.RXLKADJ = RXLKADJ_B;
defparam gt11_b.RXLKAPD = RXLKAPD_B;
defparam gt11_b.RXLOOPCAL_WAIT = RXLOOPCAL_WAIT_B;
defparam gt11_b.RXLOOPFILT = RXLOOPFILT_B;
defparam gt11_a.RXMODE = RXMODE_B;
defparam gt11_b.RXOUTDIV2SEL = RXOUTDIV2SEL_B;
defparam gt11_b.RXPD = RXPD_B;
defparam gt11_b.RXPDDTST = RXPDDTST_B;
defparam gt11_b.RXPLLNDIVSEL = RXPLLNDIVSEL_B;
defparam gt11_b.RXPMACLKSEL = RXPMACLKSEL_B;
defparam gt11_b.RXRCPADJ = RXRCPADJ_B;
defparam gt11_b.RXRCPPD = RXRCPPD_B;
defparam gt11_b.RXRECCLK1_USE_SYNC = RXRECCLK1_USE_SYNC_B;
defparam gt11_b.RXRIBADJ = RXRIBADJ_B;
defparam gt11_b.RXRPDPD = RXRPDPD_B;
defparam gt11_b.RXRSDPD = RXRSDPD_B;
defparam gt11_b.RXSLOWDOWN_CAL = RXSLOWDOWN_CAL_B;
defparam gt11_a.RXTUNE = RXTUNE_B;
defparam gt11_b.RXUSRDIVISOR = RXUSRDIVISOR_B;
defparam gt11_b.RXVCODAC_INIT = RXVCODAC_INIT_B;
defparam gt11_b.RXVCO_CTRL_ENABLE = RXVCO_CTRL_ENABLE_B;
defparam gt11_b.RX_BUFFER_USE = RX_BUFFER_USE_B;
defparam gt11_b.RX_CLOCK_DIVIDER = RX_CLOCK_DIVIDER_B;
defparam gt11_b.SAMPLE_8X = SAMPLE_8X_B;
defparam gt11_b.SH_CNT_MAX = SH_CNT_MAX_B;
defparam gt11_b.SH_INVALID_CNT_MAX = SH_INVALID_CNT_MAX_B;
defparam gt11_b.SLOWDOWN_CAL = SLOWDOWN_CAL_B;
defparam gt11_b.TXABPMACLKSEL = TXABPMACLKSEL_B;
defparam gt11_b.TXAPD = TXAPD_B;
defparam gt11_b.TXAREFBIASSEL = TXAREFBIASSEL_B;
defparam gt11_b.TXASYNCDIVIDE = TXASYNCDIVIDE_B;
defparam gt11_b.TXCLK0_FORCE_PMACLK = TXCLK0_FORCE_PMACLK_B;
defparam gt11_b.TXCLKMODE = TXCLKMODE_B;
defparam gt11_a.TXCLMODE = TXCLMODE_B;
defparam gt11_b.TXCPSEL = TXCPSEL_B;
defparam gt11_b.TXCRCCLOCKDOUBLE = TXCRCCLOCKDOUBLE_B;
defparam gt11_b.TXCRCENABLE = TXCRCENABLE_B;
defparam gt11_b.TXCRCINITVAL = TXCRCINITVAL_B;
defparam gt11_b.TXCRCINVERTGEN = TXCRCINVERTGEN_B;
defparam gt11_b.TXCRCSAMECLOCK = TXCRCSAMECLOCK_B;
defparam gt11_b.TXCTRL1 = TXCTRL1_B;
defparam gt11_b.TXDATA_SEL = TXDATA_SEL_B;
defparam gt11_b.TXDAT_PRDRV_DAC = TXDAT_PRDRV_DAC_B;
defparam gt11_b.TXDAT_TAP_DAC = TXDAT_TAP_DAC_B;
defparam gt11_b.TXDIGPD = TXDIGPD_B;
defparam gt11_b.TXFDCAL_CLOCK_DIVIDE = TXFDCAL_CLOCK_DIVIDE_B;
defparam gt11_b.TXHIGHSIGNALEN = TXHIGHSIGNALEN_B;
defparam gt11_b.TXLOOPFILT = TXLOOPFILT_B;
defparam gt11_b.TXLVLSHFTPD = TXLVLSHFTPD_B;
defparam gt11_b.TXOUTCLK1_USE_SYNC = TXOUTCLK1_USE_SYNC_B;
defparam gt11_b.TXOUTDIV2SEL = TXOUTDIV2SEL_B;
defparam gt11_b.TXPD = TXPD_B;
defparam gt11_b.TXPHASESEL = TXPHASESEL_B;
defparam gt11_b.TXPLLNDIVSEL = TXPLLNDIVSEL_B;
defparam gt11_b.TXPOST_PRDRV_DAC = TXPOST_PRDRV_DAC_B;
defparam gt11_b.TXPOST_TAP_DAC = TXPOST_TAP_DAC_B;
defparam gt11_b.TXPOST_TAP_PD = TXPOST_TAP_PD_B;
defparam gt11_b.TXPRE_PRDRV_DAC = TXPRE_PRDRV_DAC_B;
defparam gt11_b.TXPRE_TAP_DAC = TXPRE_TAP_DAC_B;
defparam gt11_b.TXPRE_TAP_PD = TXPRE_TAP_PD_B;
defparam gt11_b.TXSLEWRATE = TXSLEWRATE_B;
defparam gt11_b.TXTERMTRIM = TXTERMTRIM_B;
defparam gt11_a.TXTUNE = TXTUNE_B;
defparam gt11_b.TX_BUFFER_USE = TX_BUFFER_USE_B;
defparam gt11_b.TX_CLOCK_DIVIDER = TX_CLOCK_DIVIDER_B;
defparam gt11_b.VCODAC_INIT = VCODAC_INIT_B;
defparam gt11_b.VCO_CTRL_ENABLE = VCO_CTRL_ENABLE_B;
defparam gt11_b.VREFBIASMODE = VREFBIASMODE_B;


endmodule
